/*:
 * @target MZ
 * @plugindesc [HS] PKD_Spine2DPlayer：状態復元時のSpine二重生成を防止
 * @author HS
 * @help
 * PKD_Spine2DPlayer.js より下に配置してください。
 *
 * やっていること：
 *   PKD_Sprite_SpineAnimation.FromSaveData(saveData) を上書きして、
 *   同じIDのSpineが既に存在する場合は new せずに applySavedata だけ行います。
 */

(() => {
  if (!window.PKD_Sprite_SpineAnimation) return;

  const Klass = PKD_Sprite_SpineAnimation;
  const _FromSaveData = Klass.FromSaveData;

  Klass.FromSaveData = function(saveData) {
    try {
      if (!saveData) return null;
      const id = saveData.id;

      // すでに同IDのSpineインスタンスがあれば再利用する
      const existing = (typeof Klass.ByID === "function") ? Klass.ByID(id) : null;
      if (existing && existing.parent) {
        if (typeof existing.applySavedata === "function") {
          existing.applySavedata(saveData);
        }
        return existing;
      }
    } catch (e) {
      console.warn("[HS_PKDSpine_NoDuplicateFromSave] reuse failed:", e);
    }

    // 既存がなければ元の挙動（新規生成）にフォールバック
    return _FromSaveData.call(this, saveData);
  };

})();
